/*
 * Decompiled with CFR 0.152.
 */
package logic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;

public final class Sorter {
    private Sorter() {
    }

    public static <T extends Comparable<? super T>> void sortSeq(List<T> list) {
        Sorter.sortSeq(list, Sorter.naturalOrder());
    }

    public static <T> void sortSeq(List<T> list, Comparator<? super T> cmp) {
        if (list.size() < 2) {
            return;
        }
        ArrayList<T> a = new ArrayList<T>(list);
        ArrayList<T> aux = new ArrayList<T>(a);
        Sorter.mergeSortSeq(a, aux, 0, a.size() - 1, cmp);
        int i = 0;
        while (i < list.size()) {
            list.set(i, a.get(i));
            ++i;
        }
    }

    public static <T extends Comparable<? super T>> void sortPar(List<T> list) {
        Sorter.sortPar(list, Sorter.naturalOrder());
    }

    public static <T> void sortPar(List<T> list, Comparator<? super T> cmp) {
        Sorter.sortPar(list, cmp, ForkJoinPool.commonPool());
    }

    public static <T> void sortPar(List<T> list, Comparator<? super T> cmp, ForkJoinPool pool) {
        if (list.size() < 2) {
            return;
        }
        ArrayList<T> a = new ArrayList<T>(list);
        ArrayList<T> aux = new ArrayList<T>(a);
        pool.invoke(new MergeTask<T>(a, aux, 0, a.size() - 1, cmp, 50000, 24));
        int i = 0;
        while (i < list.size()) {
            list.set(i, a.get(i));
            ++i;
        }
    }

    private static <T> void mergeSortSeq(List<T> a, List<T> aux, int lo, int hi, Comparator<? super T> c) {
        if (hi - lo + 1 <= 24) {
            Sorter.insertion(a, lo, hi, c);
            return;
        }
        int mid = lo + hi >>> 1;
        Sorter.mergeSortSeq(a, aux, lo, mid, c);
        Sorter.mergeSortSeq(a, aux, mid + 1, hi, c);
        if (c.compare(a.get(mid), a.get(mid + 1)) <= 0) {
            return;
        }
        Sorter.merge(a, aux, lo, mid, hi, c);
    }

    private static <T> void merge(List<T> a, List<T> aux, int lo, int mid, int hi, Comparator<? super T> c) {
        int k = lo;
        while (k <= hi) {
            aux.set(k, a.get(k));
            ++k;
        }
        int i = lo;
        int j = mid + 1;
        int k2 = lo;
        while (k2 <= hi) {
            if (i > mid) {
                a.set(k2, aux.get(j++));
            } else if (j > hi) {
                a.set(k2, aux.get(i++));
            } else if (c.compare(aux.get(j), aux.get(i)) < 0) {
                a.set(k2, aux.get(j++));
            } else {
                a.set(k2, aux.get(i++));
            }
            ++k2;
        }
    }

    private static <T> void insertion(List<T> a, int lo, int hi, Comparator<? super T> c) {
        int i = lo + 1;
        while (i <= hi) {
            T key = a.get(i);
            int j = i - 1;
            while (j >= lo && c.compare(a.get(j), key) > 0) {
                a.set(j + 1, a.get(j));
                --j;
            }
            a.set(j + 1, key);
            ++i;
        }
    }

    private static <T> Comparator<? super T> naturalOrder() {
        return (o1, o2) -> ((Comparable)o1).compareTo(o2);
    }

    private static final class MergeTask<T>
    extends RecursiveAction {
        private final List<T> a;
        private final List<T> aux;
        private final int lo;
        private final int hi;
        private final Comparator<? super T> c;
        private final int parallelCutoff;
        private final int insertionCutoff;

        MergeTask(List<T> a, List<T> aux, int lo, int hi, Comparator<? super T> c, int parallelCutoff, int insertionCutoff) {
            this.a = a;
            this.aux = aux;
            this.lo = lo;
            this.hi = hi;
            this.c = c;
            this.parallelCutoff = parallelCutoff;
            this.insertionCutoff = insertionCutoff;
        }

        @Override
        protected void compute() {
            int n = this.hi - this.lo + 1;
            if (n <= this.insertionCutoff) {
                Sorter.insertion(this.a, this.lo, this.hi, this.c);
                return;
            }
            int mid = this.lo + this.hi >>> 1;
            if (n >= this.parallelCutoff) {
                MergeTask.invokeAll(new MergeTask<T>(this.a, this.aux, this.lo, mid, this.c, this.parallelCutoff, this.insertionCutoff), new MergeTask<T>(this.a, this.aux, mid + 1, this.hi, this.c, this.parallelCutoff, this.insertionCutoff));
            } else {
                Sorter.mergeSortSeq(this.a, this.aux, this.lo, mid, this.c);
                Sorter.mergeSortSeq(this.a, this.aux, mid + 1, this.hi, this.c);
            }
            if (this.c.compare(this.a.get(mid), this.a.get(mid + 1)) <= 0) {
                return;
            }
            Sorter.merge(this.a, this.aux, this.lo, mid, this.hi, this.c);
        }
    }
}

